//=============================================================================
// Utility Gun, set up security systems in a breeze!
//=============================================================================
class MSUtilityGun extends DeusExWeapon;

var travel int SelectionMode;
var travel int ViewPointMode;
var() string SelCycleMessages[8];
var() string ViewCycleMessages[3];
var actor selected;
var Name SelCameraCrap;
var Name SelTurretCrap;

replication
{
     reliable if (Role == ROLE_Authority)
        createTurretWindow, createTerminalWindow, createCameraWindow, SelectionMode, ViewPointMode;

     reliable if (Role < ROLE_Authority)
        setTurret, SelTurretCrap, SelCameraCrap, setCamera, setTerminal;
}

state NormalFire
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;


				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
  if (SelectionMode == 0)
  {
    Spawn(class'AutoTurret',,, HitLocation, Owner.Rotation + rot(0,33320,0));   
  }
  if (SelectionMode == 1)
  {
    Spawn(class'AutoTurretSmall',,, HitLocation, Owner.Rotation + rot(0,33320,0));   
  }
  if (SelectionMode == 2)
  {
    Spawn(class'SecurityCamera',,, HitLocation, Owner.Rotation + rot(0,33320,0));   
  }
  if (SelectionMode == 3)
  {
    Spawn(class'UtilityComputerSecurity',,, HitLocation, Owner.Rotation + rot(0,33320,0));   
  }
  if (SelectionMode == 4)
  {
   if ((Other != None) && (Other.IsA('AutoTurret')))
   {
    Selected = AutoTurret(Other);
    CreateTurretWindow();
   }
  }
  if (SelectionMode == 5)
  {
   if ((Other != None) && (Other.IsA('SecurityCamera')))
   {
    Selected = SecurityCamera(Other);
    CreateCameraWindow();
   }
  }
  if (SelectionMode == 6)
  {
   if ((Other != None) && (Other.IsA('UtilityComputerSecurity')))
   {
    Selected = UtilityComputerSecurity(Other);
    CreateTerminalWindow();
   }
  }
  if (SelectionMode == 7)
  {
   if ((Other != None) && ((Other.IsA('UtilityComputerSecurity')) || (Other.IsA('AutoTurret')) || (Other.IsA('AutoTurretGun')) || (Other.IsA('SecurityCamera'))))
   {
    Other.Destroy();
   }
  }
}

simulated function cycleammo()
{

	SelectionMode++;
	if(SelectionMode > 7)
	{
		SelectionMode = 0;
	}
	DeusExPlayer(Owner).ClientMessage(SelCycleMessages[SelectionMode]);

}

function LaserToggle()
{

	ViewPointMode++;
	if(ViewPointMode > 2)
	{
		ViewPointMode = 0;
	}
	DeusExPlayer(Owner).ClientMessage(ViewCycleMessages[ViewPointMode]);

}

function setTurret(int newDamage, float newRate, string newTag, string newTitle)
{
 if ((Selected != None) && (Selected.IsA ('AutoTurret')))
 {
  AutoTurret(Selected).SetPropertyText("gunDamage", ""$newDamage$""); //= newDamage;
  AutoTurret(Selected).SetPropertyText("fireRate", ""$newRate$""); //= newRate;
  AutoTurret(Selected).SetPropertyText( "Tag", newTag );
  AutoTurret(Selected).SetPropertyText("titleString", newTitle);
 }
}

simulated function createTurretWindow()
{
	local DeusExPlayer _Player;
	local DeusExRootWindow _root;
	local MSTurretWindow _Window;
	_Player = DeusExPlayer(Owner);
	if(_Player != None)
	{
		_Player.InitRootWindow();
		_root = DeusExRootWindow(_Player.rootWindow);
		if(_root != None)
		{
			_Window = MSTurretWindow(_root.InvokeUIScreen(Class'MSTurretWindow', True));
			if(_Window != None)
			{
                         if ((Selected != None) && (Selected.IsA('AutoTurret')))
                         {
				_Window._windowOwner = self;
                                _Window.SetGoodies(AutoTurret(Selected));
                         }
			}
		}
	}
}

function setCamera(string newTag, int newTitle) //bah, im lazy.
{
 if ((Selected != None) && (Selected.IsA ('SecurityCamera')))
 {
//  SecurityCamera(Selected).Tag = newTag;
  SecurityCamera(Selected).cameraRange = newTitle;
  SecurityCamera(Selected).SetPropertyText( "Tag", newTag );
 }
}

simulated function createCameraWindow()
{
	local DeusExPlayer _Player;
	local DeusExRootWindow _root;
	local MSCameraWindow _Window;
	_Player = DeusExPlayer(Owner);
	if(_Player != None)
	{
		_Player.InitRootWindow();
		_root = DeusExRootWindow(_Player.rootWindow);
		if(_root != None)
		{
			_Window = MSCameraWindow(_root.InvokeUIScreen(Class'MSCameraWindow', True));
			if(_Window != None)
			{
                         if ((Selected != None) && (Selected.IsA('SecurityCamera')))
                         {
				_Window._windowOwner = self;
                                _Window.SetGoodies(SecurityCamera(Selected));
                         }
			}
		}
	}
}

function setTerminal(string newDamage, string newRate, string newTag)
{
 if ((Selected != None) && (Selected.IsA ('UtilityComputerSecurity')))
 {
  UtilityComputerSecurity(Selected).Views[ViewPointMode].titleString = newRate;
  SetPropertyText( "SelCameraCrap", newDamage );
  UtilityComputerSecurity(Selected).Views[ViewPointMode].cameraTag = SelCameraCrap; 
  SetPropertyText( "SelTurretCrap", newTag );
  UtilityComputerSecurity(Selected).Views[ViewPointMode].turretTag = SelTurretCrap;
  //UtilityComputerSecurity(Selected).AdjustUtility(SelCameraCrap, newRate, SelTurretCrap, ViewPointMode);
 }
}

simulated function createTerminalWindow()
{
	local DeusExPlayer _Player;
	local DeusExRootWindow _root;
	local MSTerminalWindow _Window;
	_Player = DeusExPlayer(Owner);
	if(_Player != None)
	{
		_Player.InitRootWindow();
		_root = DeusExRootWindow(_Player.rootWindow);
		if(_root != None)
		{
			_Window = MSTerminalWindow(_root.InvokeUIScreen(Class'MSTerminalWindow', True));
			/*if(_Window != None)
			{
                         if ((Selected != None) && (Selected.IsA('UtilityComputerSecurity')))
                         {
				_Window._windowOwner = self;
                         }
			}*/
		}
	}
}

defaultproperties
{
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=0.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=0.500000
     reloadTime=0.000001
     maxRange=24000
     AccurateRange=14400
     bCanHaveScope=True
     bHasMuzzleFlash=False
     bInstantHit=True
     FireOffset=(X=-46.000000,Y=22.000000,Z=10.000000)
     ProjectileClass=None
     shakemag=0.000000
     FireSound=Sound'DeusExSounds.Weapons.LAWFire'
     SelectSound=Sound'DeusExSounds.Weapons.LAWSelect'
     InventoryGroup=255
     ReloadCount=0
     ItemName="|p1Markistan Corp Utility Gun"
     PlayerViewOffset=(X=18.000000,Y=-18.000000,Z=-7.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LAW'
     PickupViewMesh=LodMesh'DeusExItems.LAWPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.LAW3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconLAW'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAW'
     largeIconWidth=166
     largeIconHeight=47
     invSlotsX=5
     Description="A utlity gun used for installing security grids, simply choose what to select or spawn with your change ammo button and what viewpoint for the terminal window to control with your laser toggle button."
     beltDescription="UTILITY"
     Mesh=LodMesh'DeusExItems.LAWPickup'
     CollisionRadius=27.000000
     CollisionHeight=6.600000
     Mass=5.000000"
     bCanHaveScope=True
     bHasScope=True
     BaseAccuracy=0.000000
     SelCycleMessages(0)="|p3Now Set To Spawn Turrets Mode"
     SelCycleMessages(1)="|p3Now Set To Spawn Mini Turrets Mode"
     SelCycleMessages(2)="|p3Now Set To Spawn Cameras Mode"
     SelCycleMessages(3)="|p3Now Set To Spawn Terminals Mode"
     SelCycleMessages(4)="|p7Now Set To Modify Turrets Mode"
     SelCycleMessages(5)="|p7Now Set To Modify Cameras Mode"
     SelCycleMessages(6)="|p7Now Set To Modify Terminals Mode"
     SelCycleMessages(7)="|p2Now Set To Destroy Utilities Mode"
     ViewCycleMessages(0)="|p4Now Selecting ViewPoint 1"
     ViewCycleMessages(1)="|p4Now Selecting ViewPoint 2"
     ViewCycleMessages(2)="|p4Now Selecting ViewPoint 3"
}
